import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { CompletedLotsComponent } from './completed-lots/completed-lots.component';
import { DashboardComponent } from './dashboard/dashboard.component';
import { InprocessLotsComponent } from './inprocess-lots/inprocess-lots.component';
import { LmrMasterComponent } from './lmr-master/lmr-master.component';
import { LotFormulaComponent } from './lot-formula/lot-formula.component';
import { LotPlanningApprovalComponent } from './lot-planning-approval/lot-planning-approval.component';
import { LotPlanningComponent } from './lot-planning/lot-planning.component';
import { LotProcessingComponent } from './lot-processing/lot-processing.component';
import { NewLotPlanComponent } from './new-lot-plan/new-lot-plan.component';
import { PlannedLotsComponent } from './planned-lots/planned-lots.component';
import { ProductionReportComponent } from './production-report/production-report.component';
import { ShortageCalculationComponent } from './shortage-calculation/shortage-calculation.component';
import { YieldComponent } from './yield/yield.component';


const routes: Routes = [
  {path: '', component: DashboardComponent},
  {path: 'lmr-master', component: LmrMasterComponent},
  {path: 'shortage-calculation', component: ShortageCalculationComponent},
  {path: 'lot-planning', component: LotPlanningComponent},
  {path: 'new-lot-plan', component: NewLotPlanComponent},
  {path: 'lot-formula', component: LotFormulaComponent},
  {path: 'lot-processing', component: LotProcessingComponent},
  {path: 'planned-lots', component: PlannedLotsComponent},
  {path: 'inprocess-lots', component: InprocessLotsComponent},
  {path: 'completed-lots', component: CompletedLotsComponent},
  {path: 'production-report', component: ProductionReportComponent},
  {path: 'lot-plan-approval', component: LotPlanningApprovalComponent},
  {path: 'yield', component: YieldComponent}
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class LmrRoutingModule { }
