import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-lot-planning-approval',
  templateUrl: './lot-planning-approval.component.html',
  styleUrls: ['./lot-planning-approval.component.css']
})
export class LotPlanningApprovalComponent implements OnInit {

  results;
  selectedPlan = [];
  isView = false;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getPendingLotPlannings();
  }

  getPendingLotPlannings() {
    this.service.get('bmr.php?type=getPendingLotPlannings').subscribe(response => {
      this.results = response;
    });
  }

  viewPlan(index) {
    this.selectedPlan = this.results[index];
    this.isView = true;
  }

  updateLotPlanning(action) {
    this.service.post('bmr.php?type=updateLotPlanning&action=' + action + '&id=' + this.selectedPlan['id'] + '&plan_no=' + this.selectedPlan['no'], JSON.stringify(this.selectedPlan)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Updated Successfully');
        this.isView = false;
        this.getPendingLotPlannings();
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

}
