import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-inprocess',
  templateUrl: './inprocess.component.html',
  styleUrls: ['./inprocess.component.css']
})
export class InprocessComponent implements OnInit {

  index = -1;
  results;
  selectedBMR = [];
  processes;
  stages;

  selectedStages = [];
  stage = '';

  instruction = '';
  clearance = '';
  procedure = '';
  inprocess = '';
  constructor(private service: DataAccessService, private route: ActivatedRoute, private router: Router) { }

  ngOnInit() {
    this.route.params.subscribe(params => {
      this.index = params['id'];
    });
    this.getLotPlanningLog();
  }

  getLotPlanningLog() {
    this.service.get('bmr.php?type=getLMRLog').subscribe(response => {
      this.results = response;

      this.selectedBMR = this.results[this.index];
      if (this.selectedBMR['stage_status'] == 'pending') {
        let temp = {};
        temp["stage"] = 'DISPENSING';
        this.selectedStages[this.selectedStages.length] = temp;
        this.getProcesses();
      }
    });
  }

  getProcesses() {
    this.service.get('bmr.php?type=getLotProcesses&dosage_form=' + this.selectedBMR['dosage_form']).subscribe(response => {
      this.processes = JSON.parse(JSON.stringify(response));
      this.processes.forEach(element => {
        element.checked = false;
      });
    });
  }

  addStage() {
    let temp = {};
    temp["stage"] = this.stage;
    this.selectedStages[this.selectedStages.length] = temp;
    this.stage = '';
  }

  onSave(stageForm) {
    console.log(stageForm.value);
  }

  getBMRStages() {
    this.service.get('production.php?type=getBMRStages&bmr_no=' + this.selectedBMR['id']).subscribe(response => {
      this.stages = response;
    });
  }

  saveStages() {
    if (this.selectedStages.length == 1) {
      alertify.error('Please add stages in Table');
      return;
    }
    for (let i = 0; i < this.selectedStages.length; i++) {
      let temp = this.selectedStages[i];
      temp["id"] = i + 1;
      temp['status'] = 'pending';

      let step = {};
      step['instruction'] = false;
      step['clearance'] = false;
      step['balance'] = false;
      step['area'] = false;
      step['procedure'] = false;
      step['cleaning'] = false;
      step['inprocess'] = false;
      temp['step'] = step;
      this.selectedStages[i] = temp;
    }
    this.service.post('bmr.php?type=saveLMRStages&bmr_no=' + this.selectedBMR['id'], JSON.stringify(this.selectedStages)).subscribe(response => {
      if (response['status'] === 'success') {
        alertify.success('Saved Successfully');
        this.getLotPlanningLog();
        // this.router.navigate(['/']);
      } else {
        alertify.error('An error occured, Please try again');
      }
    });
  }

  saveSteps(index) {
    let stages = this.selectedBMR['stages'];
    let stage = stages[index];
    stage['status'] = 'inprocess';

    let temp = {};
    temp['status'] = 'pending';
    if (stage['step'].instruction == true) {
      temp['checkpoints'] = [];
      stage['instructions'] = temp;
    }
    if (stage['step'].clearance == true) {
      stage['clearances'] = temp;
    }
    if (stage['step'].balance == true) {
      stage['balances'] = temp;
    }
    if (stage['step'].area == true) {
      stage['areas'] = temp;
    }
    if (stage['step'].procedure == true) {
      temp['checkpoints'] = [];
      stage['procedures'] = temp;
    }
    if (stage['step'].cleaning == true) {
      stage['cleanings'] = temp;
    }
    if (stage['step'].inprocess == true) {
      stage['inprocesses'] = temp;
    }
    stages[index] = stage;
    this.selectedBMR['stages'] = stages;

    this.service.post('bmr.php?type=saveLMRStageSteps&bmr_no=' + this.selectedBMR['id'], JSON.stringify(this.selectedBMR['stages'])).subscribe(response => {
      if (response['status'] === 'success') {
        alertify.success('Saved Successfully');
        this.getLotPlanningLog();
        // this.router.navigate(['/']);
      } else {
        alertify.error('An error occured, Please try again');
      }
    });
  }

  saveStageSteps(index) {
    let stages = this.selectedBMR['stages'];
    let stage = stages[index];
    if (stage.step.instruction) {
      stage['instructions'].status = 'done';
    }
    if (stage.step.clearance) {
      stage['clearances'].status = 'done';
    }
    if (stage.step.inprocess) {
      stage['inprocesses'].status = 'done';
    }
    if (stage.step.procedure) {
      stage['procedures'].status = 'done';
    }
    stages[index] = stage;

    this.service.post('lot.php?type=saveStepDetails&lot_no=' + this.selectedBMR['id'], JSON.stringify(stages)).subscribe(response => {
      if (response['status'] === 'success') {
        alertify.error('Saved Successfully');
        this.getLotPlanningLog();
        // this.router.navigate(['/']);
      } else {
        alertify.error('An error occured, Please try again');
      }
    });
  }

  addInstruction(index) {
    let stages = this.selectedBMR['stages'];
    let stage = stages[index];
    let instructions = stage['instructions'];
    let checkpoints = instructions['checkpoints'];
    let temp = {};
    temp['instruction'] = this.instruction;
    checkpoints[checkpoints.length] = temp;
    instructions['checkpoints'] = checkpoints;
    stage['instructions'] = instructions;
    stages[index] = stage;
    this.selectedBMR['stages'] = stages;
    this.instruction = '';
  }

  addClearance(index) {
    let stages = this.selectedBMR['stages'];
    let stage = stages[index];
    let clearances = stage['clearances'];
    let checkpoints = clearances['checkpoints'];
    let temp = {};
    temp['checkpoint'] = this.clearance;
    checkpoints[checkpoints.length] = temp;
    clearances['checkpoints'] = checkpoints;
    stage['clearances'] = clearances;
    stages[index] = stage;
    this.selectedBMR['stages'] = stages;
    this.clearance = '';
  }

  addProcedures(index) {
    let stages = this.selectedBMR['stages'];
    let stage = stages[index];
    let procedures = stage['procedures'];
    let checkpoints = procedures['checkpoints'];
    let temp = {};
    temp['checkpoint'] = this.procedure;
    checkpoints[checkpoints.length] = temp;
    procedures['checkpoints'] = checkpoints;
    stage['procedures'] = procedures;
    stages[index] = stage;
    this.selectedBMR['stages'] = stages;
    this.procedure = '';
  }

  addInprocesses(index) {
    let stages = this.selectedBMR['stages'];
    let stage = stages[index];
    let inprocesses = stage['inprocesses'];
    let checkpoints = inprocesses['checkpoints'];
    let temp = {};
    temp['checkpoint'] = this.inprocess;
    checkpoints[checkpoints.length] = temp;
    inprocesses['checkpoints'] = checkpoints;
    stage['inprocesses'] = inprocesses;
    stages[index] = stage;
    this.selectedBMR['stages'] = stages;
    this.inprocess = '';
  }

  addProcedure(value, index) {
    let stages = this.selectedBMR['stage'];
    let stage = stages[index];
    let data = stage['data'];
    data[data.length] = value;
    stage['data'] = data;
    stages[index] = stage;
    this.selectedBMR['stage'] = stages;
  }

  deleteProcedure(p, index) {
    let stages = this.selectedBMR['stage'];
    let stage = stages[index];
    let data = stage['data'];
    data.splice(p, 1);
    stage['data'] = data;
    stages[index] = stage;
    this.selectedBMR['stage'] = stages;
  }

  saveProcedure(stage, data, id) {
    this.service.post('bmr.php?type=saveProcedure&stage=' + stage + '&id=' + id, JSON.stringify(data)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.error('Procedure saved Successfully');
        this.getLotPlanningLog();
        // this.router.navigate(['/']);
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

  updateLMRMaster(action) {
    this.service.get('bmr.php?type=updateLMRMaster&action=' + action + '&id=' + this.selectedBMR['id']).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.error('LMR Master updated successfully');
        this.getLotPlanningLog();
        // this.router.navigate(['/']);
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

}
