import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-inprocess',
  templateUrl: './inprocess.component.html',
  styleUrls: ['./inprocess.component.css']
})
export class InprocessComponent implements OnInit {
  
  isView = false;
  results;
  operators;
  equipments;

  selectedIndex = -1;
  selectedBMR = [];

  selectedEquipment = [];
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getCompletedBatches();
    this.getOperators();
  }

  getCompletedBatches() {
    this.service.get('bmr.php?type=getInprocessBatches').subscribe(response => {
      this.results = response;
    });
  }

  getOperators() {
    this.service.get('bmr.php?type=getOperators').subscribe(response => {
      this.operators = response;
    });
  }

  view(index) {
    this.selectedIndex = index;
    this.selectedBMR = this.results[index];
    this.getEquipments(this.selectedBMR['current_stage']);
    this.isView = true;
  }

  getEquipments(stage) {
    this.service.get('bmr.php?type=getProcessEquipments&stage=' + stage).subscribe(response => {
      this.equipments = response;
    });
  }

  getEquipmentDetails(index) {
    index = index - 1;
    this.selectedEquipment = this.equipments[index];
  }

  getCurrentTime(action, index) {
    var d = new Date(),
    h = (d.getHours()<10?'0':'') + d.getHours(),
    m = (d.getMinutes()<10?'0':'') + d.getMinutes();
    /* let time = new Date().toLocaleTimeString(); */
    let blendings = this.selectedBMR['blending'];
    let blending = blendings[index];
    blending[action] = h + ':' + m;
    blendings[index] = blending;
    this.selectedBMR['blending'] = blendings;
  }

  saveBledingClearance() {
    this.selectedBMR['lineclearance'].blending.prepare_by = localStorage.getItem('emp_id');
    this.selectedBMR['lineclearance'].blending.status = 'done';
    this.service.post('bmr.php?type=saveUpdatedBMR', JSON.stringify(this.selectedBMR)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('BMR Updated Successfully');
        this.getCompletedBatches();
        this.isView = false;
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

  saveProcedure(index) {
    let blendings = this.selectedBMR['blending'];
    let blending = blendings[index];
    blending['date'] = new Date().toLocaleDateString('en-CA');
    blending['status'] = 'done';
    blendings[index] = blending;
    this.selectedBMR['blending'] = blendings;
    if (this.selectedBMR['blending_stage'] == 3) {
      this.selectedBMR['current_stage'] = 'PACKING';
      this.selectedBMR['complete_date'] = new Date().toLocaleDateString('en-CA');
      this.selectedBMR['mfg_date'] = new Date().toLocaleDateString('en-CA');
      this.selectedBMR['exp_date'] = new Date(new Date().setMonth(new Date().getMonth()+ +this.selectedBMR["shelf_life"])).toLocaleDateString('en-CA');
    }
    this.selectedBMR['blending_stage'] = index + 2;
    this.service.post('bmr.php?type=saveUpdatedBMR&id=' + this.selectedBMR['id'], JSON.stringify(this.selectedBMR)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Procedure has been saved successfully');
        this.getCompletedBatches();
        this.isView = false;
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

  saveBlendingProcedure(data) {
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }
    this.selectedBMR['current_stage'] = 'PACKING';
    let results = this.results;
    results[this.selectedIndex] = this.selectedBMR;
    this.service.post('bmr.php?type=saveUpdatedBMR', JSON.stringify(results)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('BMR Updated Successfully');
        this.getCompletedBatches();
        this.isView = false;
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

}
