import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-planned',
  templateUrl: './planned.component.html',
  styleUrls: ['./planned.component.css']
})
export class PlannedComponent implements OnInit {
  products;
  results;
  selectedBMR = [];
  isNew = false;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getPlannedLots();
  }

  getPlannedLots() {
    this.service.get('batch.php?type=getPlannedBatches').subscribe(response => {
      this.results = response;
    });
  }

  viewBatch(index) {
    this.selectedBMR = this.results[index];
    this.isNew = true;
  }

  startBatch() {
    this.service.get('batch.php?type=startBatch&id=' + this.selectedBMR['id']).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Batch Started Successfully');
        this.isNew = false;
        this.getPlannedLots();
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

}
