import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-batch-planning-checking',
  templateUrl: './batch-planning-checking.component.html',
  styleUrls: ['./batch-planning-checking.component.css']
})
export class BatchPlanningCheckingComponent implements OnInit {

  entries;
  selectedData;
  isView = false;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getBatchPlannings();
  }

  getBatchPlannings() {
    this.service.get('production.php?type=getPendingBatchPlannings').subscribe(response => {
      this.entries = response;
    });
  }

  viewData(index) {
    this.selectedData = this.entries[index];
    this.isView = true;
  }

  updateBatchPlanning(value) {
    this.service.get('production.php?type=updatePendingBatchPlanning&no=' + this.selectedData['no'] + '&action=' + value).subscribe(response => {
      if (response['status'] === 'success') {
        this.getBatchPlannings();
        this.isView = false;
        alertify.success('Updated Successfully');
      } else {
        alertify.error('An error occured');
      }
    });
  }

}
