import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { DashboardComponent } from './dashboard/dashboard.component';
import { FormsModule } from '@angular/forms';
import { ClarityModule } from '@clr/angular';
import { RouterModule, Routes } from '@angular/router';

const routes: Routes = [
  { path: '', component: DashboardComponent},
  { path: 'instruction', loadChildren: () => import('./instruction/instruction.module').then(m=>m.InstructionModule)},
  { path: 'batchformula', loadChildren: () => import('./batchformula/batchformula.module').then(m=>m.BatchformulaModule)},
  { path: 'master', loadChildren: () => import('./master/master.module').then(m=>m.MasterModule)},
  { path: 'process', loadChildren: () => import('./process/process.module').then(m=>m.ProcessModule)},
];

@NgModule({
  declarations: [DashboardComponent],
  imports: [
    CommonModule,
    FormsModule,
    ClarityModule,
    RouterModule.forChild(routes)
  ]
})
export class EbmrModule { }
