import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-approval',
  templateUrl: './approval.component.html',
  styleUrls: ['./approval.component.css']
})
export class ApprovalComponent implements OnInit {

  isView = false;
  results;

  selectedResult = [];
  constructor(private service: DataAccessService) { }

  ngOnInit(): void {
    this.getPendingInstrution();
  }


  getPendingInstrution(){
    this.service.get('production/instruction.php?type=getPendingInstructions').subscribe(response=> {
      this.results = response;
    });
  }

  view(index){
    this.selectedResult = this.results[index];
    this.isView = true;
  }


  action(status){
    this.service.get('production/instruction.php?type=updateInstruction&status=' + status + '&id=' + this.selectedResult['id']).subscribe(response=>{
      if (response['status'] == 'success') {
        alertify.success('Data Updated Successfully!');
        this.isView = false;
        this. getPendingInstrution();
      } else {
        alertify.error('Failed: An error occured, please try again!');
      }
    });
  }
  
}
