import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-approval',
  templateUrl: './approval.component.html',
  styleUrls: ['./approval.component.css']
})
export class ApprovalComponent implements OnInit {
  isView = false;
  results;

  selectedResult = [];
  specification = [];
  specification1 = [];
  constructor(private service: DataAccessService) { }

  ngOnInit(): void {
    this.getMFRs();
  }
  updateMFR(status){
    this.service.get('production/master.php?type=updateMFR&status='+status+'&id='+this.selectedResult['id']).subscribe(response=>{
      if(response['status']=='success'){
        alertify.success('Mfrs updated successfuly');
        this.getMFRs();
        this.isView=false;
      }else{
        alertify.error('some error ocuured');
      }
    });
  }

  getMFRs() {
    this.service.get('production/master.php?type=getActiveMFRs').subscribe(response => {
      this.results = response;
    });
  }

  view(index) {
    this.selectedResult = this.results[index];
    this.specification = this.selectedResult['specification'];
    this.specification1 = this.selectedResult['specification1'];
    this.isView = true;
  }

  close() {
    this.isView = false;
  }


}
