import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-new',
  templateUrl: './new.component.html',
  styleUrls: ['./new.component.css']
})
export class NewComponent implements OnInit {
  products;
  selectedResult=[];
  stageList=[];
  constructor(private service:DataAccessService,private router:Router) { }

  ngOnInit() {
  }

  getProductsByDosage(value) {
    this.service.get('production/process.php?type=getProductsByDosage&product_type=' + value).subscribe(response => {
      this.products = response;
    });
  }

  getDetails(index) {
    index = index - 1;
    if (index !== -1) {
      this.selectedResult = this.products[index];
    }
  }

  addStage(data){
    this.stageList[this.stageList.length]=data.value;
    data.reset();
  }
  deletestep(index){
    this.stageList.splice(index,1);
  }
  saveProcess(data){
    if (!data.valid) {
      alertify.error('All fields are required!');
      return;
    }
    let temp=data.value;
    temp['stages']=this.stageList;
    this.service.post('production/process.php?type=saveProcess', JSON.stringify(temp)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Product MFR initiated successfully!');
        this.router.navigate(['/ebmr']);
      } else {
        alertify.error('Failed: An error occured, please try again!');
      }
    });
  }
}
