import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';

@Component({
  selector: 'app-dispensing-checking',
  templateUrl: './dispensing-checking.component.html',
  styleUrls: ['./dispensing-checking.component.css']
})
export class DispensingCheckingComponent implements OnInit {

  isRecord = true;
  results;
  selectedBP = [];
  isShowBP = false;
  materials = [];
  isShowMaterial = false;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getProductionDispensingChecking();
  }

  getProductionDispensingChecking() {
    this.service.get('production.php?type=getProductionDispensingChecking').subscribe(response => {
      this.results = response;
      if (Object.keys(this.results).length == 0) {
        this.isRecord = true;
      } else {
        this.isRecord = false;
      }
    });
  }

  showDispensingSheet(index) {
    this.selectedBP = this.results[index];
    this.isShowBP = true;
  }

  showMaterial(index) {
    let temp = this.selectedBP["materials"];
    this.materials = temp[index];
    this.isShowMaterial = true;
  }

  checkDispensing(value) {
    this.service.get('production.php?type=checkDispensing&action=' + value + '&id=' + this.materials["id"] + '&bp_no=' + this.materials["bp_no"]).subscribe(response => {
      if (response['status'] === 'success') {
        this.getProductionDispensingChecking();
        this.isShowMaterial = false;
        this.isShowBP = false;
      }
    });
  }

}
