import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify
@Component({
  selector: 'app-new-bmr',
  templateUrl: './new-bmr.component.html',
  styleUrls: ['./new-bmr.component.css']
})
export class NewBMRComponent implements OnInit {

  isShow = false;
  entries;
  product;
  materials;
  equipments;

  equipment_name = '';
  equipment_id = '';
  sop_no = '';
  capacity = '';

  instruction = '';

  machineries = [];
  instructions;
  selectedInstructions = [];

  isInprocess = false;
  lot_no = 0;
  lots = [];
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getPendingBMR();
    this.getEquipments();
    this.getInstructions();
  }

  getPendingBMR() {
    this.service.get('production.php?type=getPendingBMR').subscribe(response => {
      this.entries = response;
    });
  }

  getEquipments() {
    this.service.get('qaDepartment.php?type=getEquipments').subscribe(response => {
      this.equipments = response;
    });
  }

  getInstructions() {
    this.service.get('production.php?type=getManufacturingInstructions').subscribe(response => {
      this.instructions = response;
    });
  }

  viewMaterial(index) {
    this.product = this.entries[index];
    this.materials = this.entries[index].materials;
    this.isShow = true;
    if (this.product['status'] === 'inprocess') {
      this.machineries = this.product['machinaries'];
      this.selectedInstructions = this.product['instructions'];
      this.isInprocess = true;
      this.lot_no = this.product['lot_no'];
      for (let i = 0; i < this.product['lot_no']; i++) {
        this.lots[i] = i+1;
      }
    }
  }

  getEquipmentDetails(index) {
    index = index - 1;
    this.equipment_id = this.equipments[index].equipment_code;
    this.sop_no = this.equipments[index].sop_no;
    this.capacity = this.equipments[index].capacity;
  }

  addEquipment() {
    if (this.equipment_name.length > 0) {
      let index = this.machineries.length;
      let temp = {};
      temp['bp_no'] = this.product['no'];
      temp['equipment_name'] = this.equipment_name;
      temp['equipment_code'] = this.equipment_id;
      temp['sop_no'] = this.sop_no;
      temp['capacity'] = this.capacity;
      this.machineries[index] = temp;
      this.equipment_name = '';
      this.equipment_id = '';
      this.sop_no = '';
      this.capacity = '';
    }
  }

  addInstruction() {
    if (this.instruction.length > 0) {
      let index = this.selectedInstructions.length;
      let temp = {};
      temp['bp_no'] = this.product['no'];
      temp['instruction'] = this.instruction;
      this.selectedInstructions[index] = temp;
      this.instruction = '';
    }
  }

  saveInitialBMR() {
    let temp = {};
    temp['machinaries'] = this.machineries;
    temp['instructions'] = this.selectedInstructions;
    this.service.post('production.php?type=saveInitialBMR', JSON.stringify(temp)).subscribe(response => {
      if (response['status'] === 'success') {
        this.machineries = [];
        this.selectedInstructions = [];
        this.getPendingBMR();
        this.isShow = false;
        alertify.success('Ok');
      } else {
        alertify.error('error');
      }
    });
  }

  saveMaterialSifting(index) {
    this.service.post('production.php?type=saveMaterialSifting', JSON.stringify(this.materials[index])).subscribe(response => {
      if (response['status'] === 'success') {
        this.getPendingBMR();
        this.isShow = false;
      }
    });
  }

  addSiftValues(value, index) {
    this.materials[index].mesh_size = value;
  }

  siftingLineClearance() {
    
  }

}
