import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-receive-dispensing',
  templateUrl: './receive-dispensing.component.html',
  styleUrls: ['./receive-dispensing.component.css']
})
export class ReceiveDispensingComponent implements OnInit {

  isRecord = true;
  results;
  selectedBP = [];
  isShowBP = false;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getProductionPendingDispensing();
  }

  getProductionPendingDispensing() {
    this.service.get('production.php?type=getProductionPendingDispensing').subscribe(response => {
      this.results = response;
      if (Object.keys(this.results).length == 0) {
        this.isRecord = true;
      } else {
        this.isRecord = false;
      }
    });
  }

  showDispensingSheet(index) {
    this.selectedBP = this.results[index];
    this.isShowBP = true;
  }

  receiveDispensing(action) {
    this.service.get('production.php?type=receiveDispensing&bp_no=' + this.selectedBP['no'] + '&action=' + action).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Successfully update.');
        this.isShowBP = false;
        this.getProductionPendingDispensing();
      } else {
        alertify.error('An error occured');
      }
    });
  }

}
