import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { DashboardComponent } from './dashboard/dashboard.component';
import { AwaitingComponent } from './awaiting/awaiting.component';
import { LogComponent } from './log/log.component';
import { CompletedComponent } from './completed/completed.component';
import { FormsModule } from '@angular/forms';
import { ClarityModule } from '@clr/angular';
import { RouterModule, Routes } from '@angular/router';
import { InprocessComponent } from './inprocess/inprocess.component';
import { NewComponent } from './new/new.component';
import { DispensingComponent } from './dispensing/dispensing.component';
import { TransfredComponent } from './transfred/transfred.component';
import { YieldComponent } from './yield/yield.component';
import { WorkComponent } from './work/work.component';
import { RequisitionComponent } from './requisition/requisition.component';
import { PlanComponent } from './plan/plan.component';
import { CheckingComponent } from './checking/checking.component';
import { ApprovalComponent } from './approval/approval.component';
import { LmrComponent } from './lmr/lmr.component';

const routes: Routes = [
  { path: '', component: DashboardComponent},
  { path: 'lmr', component: LmrComponent},
  { path: 'plan', component: PlanComponent},
  { path: 'awaiting', component: AwaitingComponent},
  { path: 'requisition', component: RequisitionComponent},
  { path: 'inprocess', component: InprocessComponent},
  { path: 'checking', component: CheckingComponent},
  { path: 'approval', component: ApprovalComponent},
  { path: 'completed', component: CompletedComponent},
  { path: 'transfred', component: TransfredComponent},
  { path: 'log', component: LogComponent},
  { path: 'new/:id', component: NewComponent},
  /* { path: 'dispensing/:id', component: DispensingComponent}, */
  { path: 'yield', component: YieldComponent},
  /* { path: 'work/:id', component: WorkComponent}, */
  { path: 'work', loadChildren: () => import('./work/work.module').then(m=>m.WorkModule)},
  { path: 'dispensing', loadChildren: () => import('./dispensing/dispensing.module').then(m=>m.DispensingModule)},
];

@NgModule({
  declarations: [DashboardComponent, AwaitingComponent, LogComponent, CompletedComponent, InprocessComponent, NewComponent, DispensingComponent, TransfredComponent, YieldComponent, WorkComponent, RequisitionComponent, PlanComponent, CheckingComponent, ApprovalComponent, LmrComponent],
  imports: [
    CommonModule,
    FormsModule,
    ClarityModule,
    RouterModule.forChild(routes)
  ]
})
export class BatchModule { }
