import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-inprocess-lots',
  templateUrl: './inprocess-lots.component.html',
  styleUrls: ['./inprocess-lots.component.css']
})
export class InprocessLotsComponent implements OnInit {

  tab1 = true;
  tab2 = false;
  tab3 = false;
  tab4 = false;
  tab5 = false;
  tab6 = false;
  tab7 = false;
  tab8 = false;

  products;
  results;
  selectedIndex = -1;
  selectedBMR = [];
  isNew = false;

  equipments;
  selectedEquipment = [];
  operators;

  data = [];

  centrifugations;
  
  materials;
  selectedCentry = [];
  
  from_time = '';
  to_time = '';
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getInprocessLots();
    this.getOperators();
  }

  getInprocessLots() {
    this.service.get('bmr.php?type=getInprocessLots').subscribe(response => {
      this.results = response;
    });
  }

  viewBatch(index) {
    this.selectedIndex = index;
    this.selectedBMR = this.results[index];
    if (this.selectedBMR['lineclearance'].manufacturing.status == 'done') {
      this.getEquipments();
    }
    this.isNew = true;
  }

  getEquipments() {
    this.service.get('bmr.php?type=getProcessEquipments&stage=MANUFACTURING').subscribe(response => {
      this.equipments = response;
    });
  }

  getEquipmentDetails(index) {
    index = index - 1;
    this.selectedEquipment = this.equipments[index];
  }

  getOperators() {
    this.service.get('bmr.php?type=getOperators').subscribe(response => {
      this.operators = response;
    });
  }

  getCurrentTime(action, index) {
    var d = new Date(),
    h = (d.getHours()<10?'0':'') + d.getHours(),
    m = (d.getMinutes()<10?'0':'') + d.getMinutes();
    /* let time = new Date().toLocaleTimeString(); */
    let manufacturings = this.selectedBMR['manufacturing'];
    let manufacturing = manufacturings[index];
    manufacturing[action] = h + ':' + m;
    manufacturings[index] = manufacturing;
    this.selectedBMR['manufacturing'] = manufacturings;
  }

  getTime(action) {
    var d = new Date(),
    h = (d.getHours()<10?'0':'') + d.getHours(),
    m = (d.getMinutes()<10?'0':'') + d.getMinutes();
    if (action == 'from_time') {
      this.from_time = h + ':' + m;
    } else {
      this.to_time = h + ':' + m;
    }
  }

  callforDispensing() {
    this.selectedBMR['dispensing'] = 'inprocess';
    this.selectedBMR['dispensing_request_by'] = localStorage.getItem('emp_id');
    this.selectedBMR['dispensing_request_date'] = new Date().toLocaleDateString('en-CA');
    this.service.post('bmr.php?type=callforDispensing&id=' + this.selectedBMR["id"], JSON.stringify(this.selectedBMR)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Dispensing Request has been send to Store Department');
        this.isNew = false;
        this.getInprocessLots();
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

  receiveDispensing() {
    this.selectedBMR['current_stage'] = 'MANUFACTURING';
    this.selectedBMR['dispensing'] = 'approve';
    this.selectedBMR['dispensing_receive_by'] = localStorage.getItem('emp_id');
    this.selectedBMR['dispensing_receive_date'] = new Date().toLocaleDateString('en-CA');
    this.service.post('bmr.php?type=callforDispensing&id=' + this.selectedBMR["id"], JSON.stringify(this.selectedBMR)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Dispensing Material Received Successfully');
        this.isNew = false;
        this.getInprocessLots();
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

  updateYieldData(index) {
    let stages = this.selectedBMR['stages'];
    let stage = stages[index];
    let data = stage['data'];
    let yield_qty = +data['fbd'] + +data['td'] + +data['rvd'];
    data['yield_qty'] = yield_qty;

    let blending = yield_qty - (+data['sample_cf'] + +data['sample_td']);
    data['blending'] = blending;
    stage['data'] = data;
    stages[index] = stage;
    this.selectedBMR['stages'] = stages;
  }

  saveLineClearance(data) {
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }
    let temp = this.selectedBMR['lineclearance'];
    let manufacturing = temp['manufacturing'];
    manufacturing['status'] = 'done';
    manufacturing['prepare_by'] = localStorage.getItem('emp_id');
    manufacturing['prepare_date'] = new Date().toLocaleDateString('en-CA');
    temp['manufacturing'] = manufacturing;
    this.selectedBMR['lineclearance'] = temp;
    this.service.post('bmr.php?type=saveLineClearance&id=' + this.selectedBMR['id'], JSON.stringify(this.selectedBMR)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Line Clearance has been successfully');
        this.getInprocessLots();
        this.isNew = false;
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

  addProcedure(data, index) {
    let manufacturings = this.selectedBMR['manufacturing'];
    let manufacturing = manufacturings[index];
    let equipmentList = manufacturing['equipments'];
    let temp = data.value;
    temp['date'] = new Date().toLocaleDateString('en-CA');
    equipmentList[equipmentList.length] = temp;
    manufacturing['equipments'] = equipmentList;
    manufacturings[index] = manufacturing;
    this.selectedBMR['manufacturing'] = manufacturings;
    data.resetForm();
  }

  saveProcedure(index) {
    let manufacturings = this.selectedBMR['manufacturing'];
    let manufacturing = manufacturings[index];

    if (this.selectedBMR['manufacturing_stage'] == 21) {
      let dryings = this.selectedBMR['drying'];
      manufacturing['from_time'] = dryings[0].from_time;
      manufacturing['to_time'] = dryings[dryings.length - 1].to_time;
      manufacturing['temp'] = dryings[dryings.length - 1].temp;
    }

    manufacturing['date'] = new Date().toLocaleDateString('en-CA');
    manufacturing['status'] = 'inprocess';
    manufacturing['entry_by'] = localStorage.getItem('emp_id');
    manufacturings[index] = manufacturing;

    this.selectedBMR['manufacturing'] = manufacturings;

    this.service.post('bmr.php?type=saveProcedure&id=' + this.selectedBMR['id'], JSON.stringify(this.selectedBMR)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Procedure has been saved successfully');
        this.getInprocessLots();
        this.isNew = false;
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

  approveProcedure(index) {
    let manufacturings = this.selectedBMR['manufacturing'];
    let manufacturing = manufacturings[index];

    manufacturing['check_date'] = new Date().toLocaleDateString('en-CA');
    manufacturing['status'] = 'done';
    manufacturing['check_by'] = localStorage.getItem('emp_id');
    manufacturings[index] = manufacturing;

    this.selectedBMR['manufacturing'] = manufacturings;
    if (this.selectedBMR['manufacturing_stage'] == 22) {
      this.selectedBMR['current_stage'] = 'YIELD';
    }

    this.selectedBMR['manufacturing_stage'] = index + 2;

    this.service.post('bmr.php?type=saveProcedure&id=' + this.selectedBMR['id'], JSON.stringify(this.selectedBMR)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.error('Procedure has been Approved successfully');
        this.getInprocessLots();
        this.isNew = false;
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

  saveYield() {
    this.selectedBMR['status'] = 'active';
    this.selectedBMR['yield_percent'] = (this.selectedBMR['yield'] * 100) / this.selectedBMR["qty"];
    this.selectedBMR['complete_date'] = new Date().toLocaleDateString('en-CA');
    this.selectedBMR['mfg_date'] = new Date().toLocaleDateString('en-CA');
    this.service.post('bmr.php?type=saveProcedure&id=' + this.selectedBMR['id'], JSON.stringify(this.selectedBMR)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.error('Yield has been saved successfully');
        this.getInprocessLots();
        this.isNew = false;
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

  addDryings(data, index) {
    let manufacturings = this.selectedBMR['manufacturing'];
    let manufacturing = manufacturings[index];
    let dryings = this.selectedBMR['drying'];
    let temp = data.value;
    temp['done_by'] = manufacturing['done_by'];
    temp['date'] = new Date().toLocaleDateString('en-CA');
    dryings[dryings.length] = temp;
    this.selectedBMR['drying'] = dryings;
  }

  saveInprocessLot() {
    this.selectedBMR['status'] = 'approve';
    this.service.post('bmr.php?type=saveProcedure&id=' + this.selectedBMR['id'], JSON.stringify(this.selectedBMR)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.error('Procedure has been saved successfully');
        this.getInprocessLots();
        this.isNew = false;
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

  changeTab(tab) {
    this.tab1 = false;
    this.tab2 = false;
    this.tab3 = false;
    this.tab4 = false;
    this.tab5 = false;
    this.tab6 = false;
    this.tab7 = false;
    this.tab8 = false;
    if (tab == 'tab2') {
      this.tab2 = true;
    } else if (tab == 'tab3') {
      this.tab3 = true;
    } else if (tab == 'tab4') {
      this.tab4 = true;
    } else if (tab == 'tab5') {
      this.tab5 = true;
    } else if (tab == 'tab6') {
      this.tab6 = true;
    } else if (tab == 'tab7') {
      this.tab7 = true;
    } else if (tab == 'tab8') {
      this.tab8 = true;
    }
  }

  downloadpdf() {
    let url = this.service.url + 'pdf1/lot.php?lot_no=' + this.selectedIndex;
    window.open(url, '_blank');
  }

}
