import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-new',
  templateUrl: './new.component.html',
  styleUrls: ['./new.component.css']
})
export class NewComponent implements OnInit {

  isNew = false;
  isView = false;
  isInprocess = false;
  results;
  dosages;

  products;
  selectedProduct = [];
  mfrs;
  selectedBatch = [];
  isProd = false;
  isBatch = false;

  lot_size = 0;

  selectedBMR = [];
  processes;
  stages;

  selectedStages = [];
  stage = '';

  instruction = '';
  constructor(private service: DataAccessService, private router: Router) { }

  ngOnInit() {
    this.getLotPlanningLog();
  }

  getLotPlanningLog() {
    this.service.get('bmr.php?type=getLMRLog').subscribe(response => {
      this.results = response;
    });
  }

  newBMR() {
    this.getDosages();
    this.isNew = true;
  }

  getDosages() {
    this.service.get('qa.php?type=getDosageForms').subscribe(response => {
      this.dosages = response;
    });
  }

  getProductsByDosage(value) {
    if (value == '') {
      this.products = [];
      return;
    }
    this.service.get('bmr.php?type=getProductsByDosage&dosage_form=' + value).subscribe(response => {
      this.products = response;
    });
  }

  getProductDetails(index) {
    index = index - 1;
    this.selectedProduct = this.products[index];
    this.mfrs = this.selectedProduct['mfrs'];
    this.isProd = true;
  }

  showBatch(index) {
    index = index - 1;
    let batches = this.selectedProduct['mfrs'];
    this.selectedBatch = batches[index];
    this.isBatch = true;
  }

  updateLotQty() {
    let materials = this.selectedBatch["mfr_materials"];
    for (let i = 0; i < materials.length; i++) {
      let material = materials[i];
      material["lot_qty"] = (material["qty"] * (this.lot_size / 1000000)).toFixed(2);
      materials[i] = material;
    }
    this.selectedBatch["mfr_materials"] = materials;
  }

  saveInitBMR(data) {
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }
    let temp = data.value;
    temp['average_weight'] = this.selectedBatch['average_weight'];
    temp['unit_weight'] = this.selectedBatch['unit'];
    temp['unit'] = 'Kg';
    temp['mfr_materials'] = this.selectedBatch["mfr_materials"];
    temp['equipments'] = this.selectedBatch["equipments"];
    this.service.post('production/master.php?type=saveInitLMR', JSON.stringify(temp)).subscribe(response => {
      if (response['status'] == 'success') {
        this.getLotPlanningLog();
        this.isNew = false;
        alertify.success('Saved Successfully');
      } else {
        alertify.error('An error occured, Please try again');
      }
    });
  }

  viewBMR(index) {
    this.isInprocess = false;
    this.isView = false;

    let flag = 1;
    this.selectedBMR = this.results[index];
    if (this.selectedBMR['status'] == 'inprocess') {
      if (this.selectedBMR['stage_status'] == 'done') {
        let stages = this.selectedBMR['stages'];
        for (let i = 0; i < stages.length; i++) {
          let stage = stages[i];
          if (stage['status'] == 'inprocess') {
            if (stage.step.instruction) {
              if (stage['instructions'].status == 'done') {
                flag = 0;
              } else {
                flag = 6;
                break;
              }
            }
            if (stage.step.clearance) {
              if (stage['clearances'].status == 'done') {
                flag = 0;
              } else {
                flag = 5;
                break;
              }
            }
            if (stage.step.inprocess) {
              if (stage['inprocesses'].status == 'done') {
                flag = 0;
              } else {
                flag = 2;
                break;
              }
            }
            if (stage.step.procedure) {
              if (stage['procedures'].status == 'done') {
                flag = 0;
              } else {
                flag = 3;
                break;
              }
            }
          } else {
            flag = 4;
            break;
          }
        }
      } else {
        flag = 7;
      }

      if (flag == 0) {
        this.isView = true;
      } else {
        this.router.navigate(['/lot/inprocess/' + index]);
      }
    } else if (this.selectedBMR['status'] == 'approve' || this.selectedBMR['status'] == 'active') {
      this.isView = true;
    }
  }

  updateLotMaster(status) {
    this.selectedBMR['status'] = 'approve';
    this.service.post('bmr.php?type=updateLotMaster&id=' + this.selectedBMR['id'], JSON.stringify(this.selectedBMR)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Master Updated Successfully');
        this.isView = false;
        this.getLotPlanningLog();
      } else {
        alertify.error('Failed: An error occured, please try again!');
      }
    });
  }

}
