import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-general-instructions',
  templateUrl: './general-instructions.component.html',
  styleUrls: ['./general-instructions.component.css']
})
export class GeneralInstructionsComponent implements OnInit {

  instruction = '';
  instructions;

  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getInstructions();
  }

  getInstructions() {
    this.service.get('production.php?type=getManufacturingInstructions').subscribe(response => {
      this.instructions = response;
    });
  }

  addInstruction() {
    if (this.instruction.length > 0) {
      this.service.get('production.php?type=saveInstructions&instruction=' + this.instruction).subscribe(response => {
        if (response['status'] === 'success') {
          let index = this.instructions.length;
          let temp = {};
          temp['instruction'] = this.instruction;
          this.instructions[index] = temp;
          this.instruction = '';
          alertify.success('saved successfully');
        } else {
          alertify.error('error');
        }
      });
    }
  }

  saveInstructions() {
    this.service.post('production.php?type=saveInstructions', JSON.stringify(this.instructions)).subscribe(response => {
      if (response['status'] === 'success') {
        this.getInstructions();
        alertify.success('saved successfully');
      } else {
        alertify.error('error');
      }
    });
  }

}
