import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-standard-bmr',
  templateUrl: './standard-bmr.component.html',
  styleUrls: ['./standard-bmr.component.css']
})
export class StandardBmrComponent implements OnInit {

  isNew = false;
  isView = false;
  isInprocess = false;
  results;
  dosages;

  products;
  selectedProduct = [];
  selectedBatch = [];
  isProd = false;
  isBatch = false;

  selectedBMR = [];
  equipments;
  processes;
  stages;
  instructions;

  equipment_index = -1;
  equipment_code = '';
  capacity = '';
  make = '';
  calibration = '';
  step = '';
  equipmentList = [];

  isDispensing = false;
  isSifting = false;
  isMilling = false;
  isDrymixing = false;

  dispensing_instruction = '';
  dispensingInstructions = [];
  dispensing_procedure = '';
  dispensingProcedures = [];

  shifting_instruction = '';
  siftingInstructions = [];
  shifting_procedure = '';
  siftingProcedures = [];

  milling_instruction = '';
  millingInstructions = [];
  milling_procedure = '';
  millingProcedures = [];

  drymixing_instruction = '';
  dryMixingInstructions = [];
  drymixing_procedure = '';
  dryMixingProcedures = [];
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getBatchPlanningLog();
  }

  getBatchPlanningLog() {
    this.service.get('production.php?type=getBMRLog').subscribe(response => {
      this.results = response;
    });
  }

  newBMR() {
    this.getDosages();
    this.isNew = true;
  }

  getDosages() {
    this.service.get('qaDepartment.php?type=getDosageForms').subscribe(response => {
      this.dosages = response;
    });
  }

  getProductsByDosage(value) {
    if (value == '') {
      this.products = [];
      return;
    }
    this.service.get('qaDepartment.php?type=getProductsByDosage&dosage_form=' + value).subscribe(response => {
      this.products = response;
    });
  }

  getProductDetails(index) {
    index = index - 1;
    this.selectedProduct = this.products[index];
    this.isProd = true;
  }

  showBatch(index) {
    index = index - 1;
    let batches = this.selectedProduct['batches'];
    this.selectedBatch = batches[index];
    this.isBatch = true;
  }

  saveInitBMR(data) {
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }
    let temp = data.value;
    temp['bom_no'] = this.selectedBatch['id'];
    temp['mf_no'] = this.selectedBatch['mf_no'];
    temp['lots'] = this.selectedBatch['lots'];
    this.service.post('production.php?type=saveInitBMR', JSON.stringify(data.value)).subscribe(response => {
      if (response['status'] == 'success') {
        this.getBatchPlanningLog();
        this.isView = false;
        alertify.success('Saved Successfully');
      } else {
        alertify.error('An error occured, Please try again');
      }
    });
  }

  viewBMR(index) {
    this.dispensing_instruction = '';
    this.dispensingInstructions = [];
    this.dispensing_procedure = '';
    this.dispensingProcedures = [];

    this.shifting_instruction = '';
    this.siftingInstructions = [];
    this.shifting_procedure = '';
    this.siftingProcedures = [];

    this.milling_instruction = '';
    this.millingInstructions = [];
    this.milling_procedure = '';
    this.millingProcedures = [];

    this.drymixing_instruction = '';
    this.dryMixingInstructions = [];
    this.drymixing_procedure = '';
    this.dryMixingProcedures = [];

    this.isDispensing = false;
    this.isSifting = false;
    this.isMilling = false;
    this.isDrymixing = false;
    this.isInprocess = false;
    this.isView = false;

    this.selectedBMR = this.results[index];
    if (this.selectedBMR['stages'] == 'pending') {
      this.getProcesses();
    }
    if (this.selectedBMR['stages'] == 'done' && this.selectedBMR['equipments'] == 'pending') {
      this.getEquipments();
      this.getBMRStages();
    }

    if (this.selectedBMR['stages'] == 'done') {
      this.getInstructions();
      let stages = this.selectedBMR['stage'];
      for (let i = 0; i < stages.length; i++) {
        let data = JSON.parse(stages[i].data);
        if (stages[i].stage == 'DISPENSING') {
          this.dispensingInstructions = data['instructions'];
          this.dispensingProcedures = data['procedures'];
          this.isDispensing = true;
        }
        if (stages[i].stage == 'SIFTING') {
          this.siftingInstructions = data['instructions'];
          this.siftingProcedures = data['procedures'];
          this.isSifting = true;
        }
        if (stages[i].stage == 'MILLING') {
          this.millingInstructions = data['instructions'];
          this.millingProcedures = data['procedures'];
          this.isMilling = true;
        }
        if (stages[i].stage == 'DRY MIXING') {
          this.dryMixingInstructions = data['instructions'];
          this.dryMixingProcedures = data['procedures'];
          this.isDrymixing = true;
        }
      }
    }
    if (this.selectedBMR['status'] == 'inprocess') {
      this.isInprocess = true;
    } else if (this.selectedBMR['status'] == 'approve' || this.selectedBMR['status'] == 'active') {
      this.isView = true;
    }
  }

  getEquipments() {
    this.service.get('production.php?type=getEquipments').subscribe(response => {
      this.equipments = response;
    });
  }

  getProcesses() {
    this.service.get('production.php?type=getProceses&dosage_form=' + this.selectedBMR['dosage_form']).subscribe(response => {
      this.processes = JSON.parse(JSON.stringify(response));
      this.processes.forEach(element => {
        element.checked = false;
      });
    });
  }

  onStepChecked(index, event) {
    this.processes[index].checked = event.target.checked;
  }

  onSave(stageForm) {
    console.log(stageForm.value);
  }

  getBMRStages() {
    this.service.get('production.php?type=getBMRStages&bmr_no=' + this.selectedBMR['id']).subscribe(response => {
      this.stages = response;
    });
  }

  getEquipmentDetails(index) {
    index = index - 1;
    this.equipment_index = index;
    this.equipment_code = this.equipments[index].equipment_code;
    this.capacity = this.equipments[index].capacity;
    this.make = this.equipments[index].make;
    this.calibration = this.equipments[index].calibration;
  }

  saveStages(data) {
    const url = 'production.php?type=saveBMRStages&bmr_no=' + this.selectedBMR['id'] + '&dosage_form=' + this.selectedBMR['dosage_form'];
    this.service.post(url, JSON.stringify(data.value)).subscribe(response => {
      const result = JSON.parse(JSON.stringify(response));
      if (result.status === 'success') {
        alertify.success('Saved Successfully');
        this.getBatchPlanningLog();
        this.isInprocess = false;
      } else {
        alertify.error('An error occured, Please try again');
      }
    });
  }

  addEquipments() {
    const equipment = this.equipments[this.equipment_index];
    equipment['stage'] = this.step;
    this.equipmentList[this.equipmentList.length] = equipment;
    this.equipments.splice(this.equipment_index, 1);
    this.equipment_index = -1;
    this.equipment_code = '';
    this.capacity = '';
    this.make = '';
    this.calibration = '';
    this.step = '';
  }

  deleteEquipment(index) {
    this.equipmentList.splice(index, 1);
  }

  saveBMREquipments() {
    if (this.equipmentList.length == 0) {
      alertify.error('Equipment List is Required');
      return;
    }
    this.service.post('production.php?type=saveBMREquipments&bmr_no=' + this.selectedBMR['id'], JSON.stringify(this.equipmentList)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('saved successfully');
        this.getBatchPlanningLog();
        this.isInprocess = false;
      } else {
        alertify.error('An error occured, please try again!');
      }
    });
  }

  getInstructions() {
    this.service.get('production.php?type=getInstructions').subscribe(response => {
      this.instructions = response;
    });
  }

  addDispensingInstructions() {
    this.dispensingInstructions[this.dispensingInstructions.length] = this.dispensing_instruction;
    this.dispensing_instruction = '';
  }

  addSiftingInstructions() {
    this.siftingInstructions[this.siftingInstructions.length] = this.shifting_instruction;
    this.shifting_instruction = '';
  }

  addShiftingProcedures() {
    this.siftingProcedures[this.siftingProcedures.length] = this.shifting_procedure;
    this.shifting_procedure = '';
  }

  addMillingInstructions() {
    this.millingInstructions[this.millingInstructions.length] = this.milling_instruction;
    this.milling_instruction = '';
  }

  addMillingProcedures() {
    this.millingProcedures[this.millingProcedures.length] = this.milling_procedure;
    this.milling_procedure = '';
  }

  addDrymixingInstructions() {
    this.dryMixingInstructions[this.dryMixingInstructions.length] = this.drymixing_instruction;
    this.drymixing_instruction = '';
  }

  addDrymixingProcedures() {
    this.dryMixingProcedures[this.dryMixingProcedures.length] = this.drymixing_procedure;
    this.drymixing_procedure = '';
  }

  saveBMRProcedures() {
    let stages = this.selectedBMR['stage'];
    for (let i = 0; i < stages.length; i++) {
      let data = JSON.parse(stages[i].data);
      if (stages[i].stage == 'DISPENSING') {

        if (this.dispensingInstructions.length == 0) {
          alertify.error('All fields are required');
          return;
        }

        data['instructions'] = this.dispensingInstructions;
        stages[i].data = data;

      }
      if (stages[i].stage == 'SIFTING') {

        if (this.siftingInstructions.length == 0) {
          alertify.error('All fields are required');
          return;
        }

        if (this.siftingProcedures.length == 0) {
          alertify.error('All fields are required');
          return;
        }

        data['instructions'] = this.siftingInstructions;
        data['procedures'] = this.siftingProcedures;
        stages[i].data = data;
      }
      if (stages[i].stage == 'MILLING') {
        if (this.millingInstructions.length == 0) {
          alertify.error('All fields are required');
          return;
        }
    
        if (this.millingProcedures.length == 0) {
          alertify.error('All fields are required');
          return;
        }

        data['instructions'] = this.millingInstructions;
        data['procedures'] = this.millingProcedures;
        stages[i].data = data;
      }
      if (stages[i].stage == 'DRY MIXING') {

        if (this.dryMixingInstructions.length == 0) {
          alertify.error('All fields are required');
          return;
        }
    
        if (this.dryMixingProcedures.length == 0) {
          alertify.error('All fields are required');
          return;
        }

        data['instructions'] = this.dryMixingInstructions;
        data['procedures'] = this.dryMixingProcedures;
        stages[i].data = data;
      }
    }
    this.service.post('production.php?type=saveBMRProcedures&id=' + this.selectedBMR['id'], JSON.stringify(stages)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Saved Successfully');
        this.getBatchPlanningLog();
        this.isInprocess = false;

        this.dispensing_instruction = '';
        this.dispensingInstructions = [];
        this.dispensing_procedure = '';
        this.dispensingProcedures = [];

        this.shifting_instruction = '';
        this.siftingInstructions = [];
        this.shifting_procedure = '';
        this.siftingProcedures = [];

        this.milling_instruction = '';
        this.millingInstructions = [];
        this.milling_procedure = '';
        this.millingProcedures = [];

        this.drymixing_instruction = '';
        this.dryMixingInstructions = [];
        this.drymixing_procedure = '';
        this.dryMixingProcedures = [];

        this.isDispensing = false;
        this.isSifting = false;
        this.isMilling = false;
        this.isDrymixing = false;
        return;
      }
    });
  }

}
