import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';

@Component({
  selector: 'app-master-formula-report',
  templateUrl: './master-formula-report.component.html',
  styleUrls: ['./master-formula-report.component.css']
})
export class MasterFormulaReportComponent implements OnInit {
  isInit = true;
  records;
  selectedRecord;
  materials;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getMasterFormulaReport();
  }

  getMasterFormulaReport() {
    this.service.get('rndDepartment.php?type=getMasterFormulaReport').subscribe(response => {
      this.records = response;
    });
  }

  viewForm(index) {
    this.selectedRecord = this.records[index];
    this.materials = this.records[index].materials;
    this.isInit = false;
  }

}
