import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-maintainance-note',
  templateUrl: './maintainance-note.component.html',
  styleUrls: ['./maintainance-note.component.css']
})
export class MaintainanceNoteComponent implements OnInit {
  isNewForm = false;
  isViewForm = false;
  equipments;
  sections;
  notes;
  selectedNote = [];
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getSections();
    this.getEquipments();
    this.getMaintenanceHistory();
  }

  getSections() {
    this.service.get('store.php?type=getStoreSections').subscribe(response => {
      this.sections = response;
    });
  }

  getEquipments() {
    this.service.get('qaDepartment.php?type=getApprovedEquipments').subscribe(response => {
      this.equipments = response;
    });
  }

  saveMaintenanceNote(data) {
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }
    this.service.post('store.php?type=saveMaintainanceNote', JSON.stringify(data.value)).subscribe(response => {
      if (response['status'] === 'success') {
        data.resetForm();
        this.isNewForm = false;
        alertify.success('Maintainance note send to maintanance department');
      } else {
        alertify.error('An error occured');
      }
    });
  }
  
  getMaintenanceHistory() {
    this.service.get('store.php?type=getMaintenanceHistory').subscribe(response => {
      this.notes = response;
    });
  }
  
  showNote(index) {
    this.selectedNote = this.notes[index];
    this.isViewForm = true;
  }

}
