import { Component, OnInit } from '@angular/core';
import { FormArray, FormBuilder, FormControl, FormGroup, ValidatorFn } from '@angular/forms';
import { Router } from '@angular/router';
import { of } from 'rxjs';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-new-incident',
  templateUrl: './new-incident.component.html',
  styleUrls: ['./new-incident.component.css']
})
export class NewIncidentComponent implements OnInit {
  affecting_product = 'yes';
  affecting_equipment = 'no';

  form: FormGroup;
  ordersData = [];
  get ordersFormArray() {
    return this.form.controls.orders as FormArray;
  }
  constructor(private service: DataAccessService, private router:Router, private formBuilder: FormBuilder) {
    this.form = this.formBuilder.group({
      orders: new FormArray([], minSelectedCheckboxes(1))
    });
    of(this.getDepartments()).subscribe(orders => {
      this.ordersData = orders;
      this.addCheckboxes();
    });
  }
  private addCheckboxes() {
    this.ordersData.forEach(() => this.ordersFormArray.push(new FormControl(false)));
  }
  getDepartments() {
    return [
      { name: 'Stores' },
      { name: 'Production' },
      { name: 'Quality Control' },
      { name: 'Packing' },
      { name: 'Marketing' },
      { name: 'Client' },
      { name: 'Regulatory Department' },
      { name: 'Management' },
      { name: 'HR' },
      { name: 'Engineering' }
    ];
  }

  ngOnInit(): void {
  }

  saveUserForm(FormData) {

    const temp = FormData.value;
    temp['departmentlist'] = this.form.value.orders.map((checked, i) => checked ? this.ordersData[i].name : null).filter(v => v !== null);
    this.service.post('incidentreporting.php?type=saveIncident', JSON.stringify(temp)).subscribe(response => {
      if(response['status'] == 'success') {
        alertify.success('Record Inserted Successfully');
        this.router.navigateByUrl('ebmr');
      }
    })

    /* this.service.post('incidentreporting.php?type=saveUserForm', JSON.stringify(formData.value))
    .subscribe(response => {
      if (response['status'] == 'sucess') {
        alert('Incident Report Saved Successfully');
      } else {
        alert('An error occured, Please try again');
      }
      },
    (error: Response) => {
      if (error.status === 400) {
        alert('An error has occurred.');
      } else {
        alert('An error has occurred, http status:' + error.status);
      }
    }); */
  }

}

function minSelectedCheckboxes(min = 1) {
  const validator: ValidatorFn = (formArray: FormArray) => {
    const totalSelected = formArray.controls
      .map(control => control.value)
      .reduce((prev, next) => next ? prev + next : prev, 0);

    return totalSelected >= min ? null : { required: true };
  };

  return validator;
}