import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
declare let alertify;
@Component({
  selector: 'app-bom',
  templateUrl: './bom.component.html',
  styleUrls: ['./bom.component.css']
})
export class BomComponent implements OnInit {

  isNew = false;
  isView = false;
  products;
  materials;
  selectedProduct = [];
  selectedMaterial = [];

  batch_size = 0;
  packing_size = 0;
  qty = 0;
  overage_qty = 0;
  overage = 0;

  materialList = [];
  boms;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getPackingBOM();
  }

  getPackingBOM() {
    this.service.get('packing.php?type=getPackingBOM').subscribe(response => {
      this.boms = response;
    });
  }

  newPacking() {
    this.getProducts();
    this.getUnits;
    this.getPackingMaterials();
    this.isNew = true;
  }

  getProducts() {
    this.service.get('packing.php?type=getProducts').subscribe(response => {
      this.products = response;
    });
  }

  getUnits() {
    this.service.get('packing.php?type=getUnits').subscribe(response => {
      this.products = response;
    });
  }

  getPackingMaterials() {
    this.service.get('packing.php?type=getPackingMaterials').subscribe(response => {
      this.materials = response;
    });
  }

  selectProduct(index) {
    index = index - 1;
    this.selectedProduct = this.products[index];
  }

  selectMaterial(index) {
    index = index - 1;
    this.selectedMaterial = this.materials[index];
  }

  calculation() {
    this.qty = this.batch_size / this.packing_size;
  }

  CalculateOverage() {
    this.overage_qty = this.qty + (this.qty * this.overage) / 100;
  }

  addMaterial() {
    this.selectedMaterial['qty'] = this.qty;
    this.selectedMaterial['overage'] = this.overage;
    this.selectedMaterial['overage_qty'] = this.overage_qty;
    this.materialList[this.materialList.length] = this.selectedMaterial;
    this.overage = 0;
    this.overage_qty = 0;
  }

  savePackingBOM(data) {
    if (!data.valid) {
      alertify.error('All fields are required');
      return;
    }
    let temp = data.value;
    temp['materials'] = this.materialList;
    this.service.post('packing.php?type=savePackingBOM', JSON.stringify(temp)).subscribe(response => {
      if (response['status'] == 'success') {
        alertify.success('Saved Successfully');
        this.isNew = false;
        this.getPackingBOM();
      }
    });
  }

}
