import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';

@Component({
  selector: 'app-bp-report',
  templateUrl: './bp-report.component.html',
  styleUrls: ['./bp-report.component.css']
})
export class BpReportComponent implements OnInit {

  isRecord = true;
  entries;
  selectedData;
  isView = false;
  constructor(private service: DataAccessService) { }

  ngOnInit() {
    this.getBatchPlannings();
  }

  getBatchPlannings() {
    this.service.get('production.php?type=getBatchPlannings').subscribe(response => {
      this.entries = response;
      if (Object.keys(this.entries).length == 0) {
        this.isRecord = true;
      } else {
        this.isRecord = false;
      }
    });
  }

  viewData(index) {
    this.selectedData = this.entries[index];
    this.isView = true;
  }

}
